unit ShowU;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, GR32_Image, GR32;

type
  TShowFrm = class(TForm)
    ImgView321: TImgView32;
    btnZoomIn: TButton;
    btnZoomOut: TButton;
    btnDefault: TButton;
    btnDelete: TButton;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnZoomInClick(Sender: TObject);
    procedure btnZoomOutClick(Sender: TObject);
    procedure btnDefaultClick(Sender: TObject);
    procedure btnDeleteClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ShowFrm: TShowFrm;

implementation

uses MainU;

{$R *.dfm}

procedure TShowFrm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 Action:= caHide;
end;

procedure TShowFrm.btnZoomInClick(Sender: TObject);
begin
 ImgView321.Scale:= ImgView321.Scale*2;
 btnZoomOut.Enabled:= true;
 if ImgView321.Scale = 8 then btnZoomIn.Enabled:= false;
end;

procedure TShowFrm.btnZoomOutClick(Sender: TObject);
begin
 ImgView321.Scale:= ImgView321.Scale/2;
 btnZoomIn.Enabled:= true;
 if ImgView321.Scale = 1/8 then btnZoomOut.Enabled:= false;
end;

procedure TShowFrm.btnDefaultClick(Sender: TObject);
begin
 ImgView321.Scale:=1;
 btnZoomIn.Enabled:= true;
 btnZoomOut.Enabled:= true;
end;

procedure TShowFrm.btnDeleteClick(Sender: TObject);
begin
 Img.Width:=0;
 Img.Height:=0;
 ImgView321.Bitmap.Assign(Img);
 FormShow(Self);
end;

procedure TShowFrm.FormShow(Sender: TObject);
begin
 with ImgView321.Bitmap do if (Width>0) and (Height>0) then
  begin
   btnZoomIn.Enabled:= True;
   btnZoomOut.Enabled:= True;
   btnDefault.Enabled:= True;
   btnDelete.Enabled:= True;
  end
 else
  begin
   btnZoomIn.Enabled:= False;
   btnZoomOut.Enabled:= False;
   btnDefault.Enabled:= False;
   btnDelete.Enabled:= False;
   ImgView321.Scale:= 1;
   SetSize(76,22);
   Clear(Color32(clBtnFace));
   RenderText(0,0,'[ empty ]',4,Color32(clMenuText));
  end;
end;

procedure TShowFrm.FormCreate(Sender: TObject);
begin
 with ImgView321.Bitmap.Font do
  begin
   Name:= 'Verdana';
   Size:= 12;  
  end;
end;

end.

